//+------------------------------------------------------------------+
//|                                                   PChannel_m.mq4 |
//+------------------------------------------------------------------+

#property indicator_chart_window //     (,  )
#property indicator_buffers 5 //    
#property indicator_color1 DodgerBlue //     1 
#property indicator_color2 DodgerBlue //     2 
#property indicator_color3 DodgerBlue //     3 
#property indicator_color4 Red //   up 
#property indicator_color5 Yellow //   Down 
//---- input parameters //   
extern int Range=14; //     14
extern int Distance_to_the_arrow=10;//  
extern int Size_arrow=3;// 
extern bool Alerts=true;/// .
extern int Shift=0;// 
extern int Proboi_Punkts=5;
//---- buffers
double UpBuffer[]; //  UpBuffer  "   "
double DnBuffer[]; //  DnBuffer  "   "
double MdBuffer[]; //  MdBuffer  "   "
double G_ibuf_92[];
double G_ibuf_96[];

int Barr;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() // 
  {
  
   if (Digits == 3 || Digits == 5)
        {
        Proboi_Punkts=Proboi_Punkts*10;
        }
  
   string short_name; //  short_name  ""
//---- indicator line
   SetIndexStyle(0,DRAW_LINE,1,2); //     
   SetIndexStyle(1,DRAW_LINE,1,2); //     
   SetIndexStyle(2,DRAW_LINE,2); //     
   SetIndexBuffer(0,UpBuffer); //   0    UpBuffer
   SetIndexBuffer(1,DnBuffer); //   1    DnBuffer
   SetIndexBuffer(2,MdBuffer); //   2    MdBuffer
   SetIndexStyle(4, DRAW_ARROW, STYLE_SOLID, Size_arrow);
   SetIndexStyle(3, DRAW_ARROW, STYLE_SOLID, Size_arrow);
   SetIndexArrow(4, 233);
   SetIndexArrow(3, 234);
   SetIndexBuffer(4, G_ibuf_92);
   SetIndexBuffer(3, G_ibuf_96);
//---- name for DataWindow and indicator subwindow label
   short_name="PriceChannel("+Range+")";  // short_name  
                                                  //  
   IndicatorShortName(short_name);  //      
                                    //
   SetIndexLabel(0,"Up Channel");   //      
                                    // 0   Up Channel
   SetIndexLabel(1,"Down Channel"); //      
                                    // 1   Down Channel
   SetIndexLabel(2,"Middle Channel"); //      
                                      // 2   Middle Channel
//----
   SetIndexDrawBegin(0,0); //     0 
   SetIndexDrawBegin(1,0); //     1 
   SetIndexDrawBegin(2,0); //     2 
//----
   return(INIT_SUCCEEDED); //   
  }
//+------------------------------------------------------------------+
//| PriceChannel                                                     |
//+------------------------------------------------------------------+
int start() //  ()
  {
   int i; //   i,k,sch

//----
   
   for(i=Bars-1;i>=0;i--)
   {
      UpBuffer[i]=High[Highest(NULL,0,MODE_UPPER,Range,i)];
      DnBuffer[i]=Low[Lowest(NULL,0,MODE_LOWER,Range,i)];
      MdBuffer[i]=(UpBuffer[i]+DnBuffer[i])/2;
      if(Iminn(i+Shift)<DnBuffer[i+Shift] &&DnBuffer[i+Shift]-Iminn(i+Shift)>=Proboi_Punkts*Point )G_ibuf_92[i]=Iminn(i)-Distance_to_the_arrow*Point;
      if(Imaxx(i+Shift)>UpBuffer[i+Shift] &&Imaxx(i+Shift)-UpBuffer[i+Shift]>=Proboi_Punkts*Point)G_ibuf_96[i]=Imaxx(i)+Distance_to_the_arrow*Point;
   }
   
   
   if(Iminn(Shift)<DnBuffer[Shift]&&DnBuffer[Shift]-Bid>=Proboi_Punkts*Point)
   {
   G_ibuf_92[0]=Iminn(0)-Distance_to_the_arrow*Point;
   if(Barr!=Bars)
   {
   string Comm=Symbol()+";"+f0_0(Period())+";"+"UP";
   if(Alerts)Alert(Comm);
   Barr=Bars;
   }
   }
   
   if(Imaxx(Shift)>UpBuffer[Shift]&&Bid-UpBuffer[Shift]>=Proboi_Punkts*Point)
   {
   G_ibuf_96[0]=Imaxx(0)+Distance_to_the_arrow*Point;
    if(Barr!=Bars)
   {
    Comm=Symbol()+";"+f0_0(Period())+";"+"Down";
   if(Alerts)Alert(Comm);
   Barr=Bars;
   }
   }
   return(0);
  }
//+------------------------------------------------------------------+
string f0_0(int Ai_0) {
   if (Ai_0 == 1) return ("M1");
   if (Ai_0 == 5) return ("M5");
   if (Ai_0 == 15) return ("M15");
   if (Ai_0 == 30) return ("M30");
   if (Ai_0 == 60) return ("H1");
   if (Ai_0 == 240) return ("H4");
   if (Ai_0 == 1440) return ("D1");
   if (Ai_0 == 10080) return ("W1");
   if (Ai_0 == 43200) return ("MN1");
   return ("");
}


 double Imaxx(int Per)
   {double perr;
    perr = NormalizeDouble (iHigh(Symbol(),0,Per),Digits);
    return (perr);
   }
   //-----//
   double Iminn(int Per)
   {double perr;
    perr = NormalizeDouble (iLow(Symbol(),0,Per),Digits);
    return (perr);
   }
   //-- --//
   double Cotkr(int Per)
   {double perr;
    perr = NormalizeDouble (iOpen(Symbol(),0,Per),Digits);
    return (perr);
    }
    //-- --//
    double Czakr(int Per)
   {double perr;
    perr = NormalizeDouble (iClose(Symbol(),0,Per),Digits);
    return (perr);
   }
   